define(function () {

    var component = {
        inject: [],
        components: {},
        data: function () {
            return {
                loadFoldOut: false,
                loadFoldOutHub: false,
                loadFoldOutLocal: false,
                showHubNavigation: false,
                hubnavigation: null,
                showLocalNavigation: false,
                localnavigation: null,
                menu: null,
                navigatedToUrl: null,
                renderFoldOutInFullWidth: true
            };
        },
        created: function () {
            var _this = this;
            var templateBase = this;
            this.renderFoldOutInFullWidth = templateBase.megamenuConfiguration.RenderFoldOutInFullWidth;
            templateBase.getMenu().then(function (result) {
                _this.menu = result;
            });
            // show/hide hub and local navigation
            this.showHubNavigation = templateBase.megamenuConfiguration.ShowHubNavigation;
            this.showLocalNavigation = templateBase.megamenuConfiguration.ShowLocalNavigation;
            if (this.showHubNavigation) {
                templateBase.getHubNavigation().then(function (result) {
                    _this.hubnavigation = result;
                });
            }
            if (this.showLocalNavigation && this.currentSiteIsCommunicationSite) {
                templateBase.getLocalNavigation().then(function (result) {
                    _this.localnavigation = result;
                    _this.webTitle = templateBase.contextProxy.get("pageContext.web.title");
                    _this.webUrl = templateBase.contextProxy.get("pageContext.web.absoluteUrl");
                });
            }
            templateBase.contextProxy.get("application.navigatedEvent").add(this, function (args) {
                if (_this.navigatedToUrl !== window.location.href) {
                    // hide foldouts after a non pageload navigation.
                    _this.closeFoldouts();
                    _this.navigatedToUrl = window.location.href;
                }
            });
        },
        methods: {
            mouseleave: function (event) {
                // removes all active style classes when the user thouch outside of the megamenu.         
                this.removeActiveStyleClassOnElements(event.target.childNodes);
            },
            removeActiveStyleClassOnElements: function (elements) {
                var activeClass = "active";
                for (var index = 0; index < elements.length; index++) {
                    var element = elements[index];
                    if (element.classList && element.classList.contains(activeClass)) {
                        element.classList.remove(activeClass);
                    }
                }
            },
            hubItemClick: function (hubItem) {
                var that = this;
                return function (event) {
                    var activeClass = "active";
                    that.removeActiveStyleClassOnElements(event.target.parentElement.parentElement.childNodes);
                    event.target.parentElement.classList.add(activeClass);
                    // Navigate on click. Navigate on double touch.
                    if (hubItem.url) {
                        if (event.type == "touchend") {
                            if (that.urlToNavigate && that.urlToNavigate === hubItem.url) {
                                window.location.href = hubItem.url;
                            }
                            else {
                                that.urlToNavigate = hubItem.url;
                            }
                        }
                        else {
                            // Most likely event.type == "click"       
                            window.location.href = hubItem.url;
                        }
                    }
                    else {
                        that.urlToNavigate = "";
                    }
                };
            },
            topItemClick: function (item) {
                var navigate = function (navigateItem) {
                    if (navigateItem.value.openInNewWindow) {
                        var win = window.open(navigateItem.value.href, "_blank");
                        win.focus();
                    }
                    else {
                        window.location.href = navigateItem.value.href;
                    }
                };
                var that = this;
                return function (event) {
                    var activeClass = "active";
                    that.removeActiveStyleClassOnElements(event.target.parentElement.parentElement.childNodes);
                    event.target.parentElement.classList.add(activeClass);
                    // Navigate on click. Navigate on double touch.
                    if (item.value && item.value.href) {
                        if (event.type == "touchend") {
                            if (that.urlToNavigate && that.urlToNavigate === item.value.href) {
                                navigate(item);
                            }
                            else {
                                that.urlToNavigate = item.value.href;
                            }
                        }
                        else {
                            // most likely event.type == "click"
                            navigate(item);
                        }
                    }
                    else {
                        that.urlToNavigate = "";
                    }
                };
            },
            closeFoldouts: function () {
                // Hide foldouts and unhide it after 1 sec.                    
                var foldouts = document.querySelectorAll(".horizontalmenu .topitem-foldout");
                var _loop_1 = function (index) {
                    var element = foldouts[index];
                    element.style.display = "none";
                    setTimeout(function () {
                        element.style.display = ""; // Can't use null as that doesn't set it to empty in IE
                    }, 1000);
                };
                for (var index = 0; index < foldouts.length; index++) {
                    _loop_1(index);
                }
            }
        },
        computed: {
            currentSiteIsCommunicationSite: function () {
                var templateBase = this;
                return templateBase.contextProxy.get("pageContext.web.templateName") == "68";
            }
        }
    };

    component.originalTemplate = "horizontalmenu";
    component.template = `
<div data-v-67c0d35c class="horizontalmenu" v-bind:class="[currentSiteIsCommunicationSite ? 'communicationsite': 'teamsite']">
    <ul data-v-67c0d35c class="topitem-list wizdom" v-if="menu != null"  v-on:mouseleave="mouseleave">
        <li data-v-67c0d35c class="topitem-listitem foldout-enabled" v-for="topItem in menu.children" :key="topItem" @mouseover="loadFoldOut = true" aria-haspopup="true">
            <div data-v-67c0d35c v-if="topItem.contentType == 'Html'" >
                <div data-v-67c0d35c class="topitem topitem-html" v-html="topItem.value.html" v-touch:tap="topItemClick(topItem)"></div>
            </div>
            <div data-v-67c0d35c v-else>
              <span data-v-67c0d35c class="topitem topitem-text" v-if="!topItem.value.href" v-touch:tap="topItemClick(topItem)" >{{topItem.translatedTitle || topItem.title}}</span>
              <a data-v-67c0d35c class="topitem topitem-link"  v-else-if="topItem.value.href" onclick="return false;" :href="topItem.value.href" :target="topItem.value.openInNewWindow ? '_blank':''"  v-touch:tap="topItemClick(topItem)" >{{topItem.translatedTitle || topItem.title}}</a>
            </div>
            <component data-v-67c0d35c class="topitem-foldout ms-bgColor-themePrimary ms-fontColor-themeLighterAlt" :class="[renderFoldOutInFullWidth ? 'topitem-foldout-fullwidth' : '']" v-if="loadFoldOut && topItem.children && topItem.children.length > 0" v-bind:is="foldoutTemplate" :topItem="topItem" />
        </li>
    </ul>
    <ul data-v-67c0d35c class="topitem-list hub" v-if="hubnavigation != null" v-on:mouseleave="mouseleave">
        <!-- Hub navigation top item -->
        <li data-v-67c0d35c class="topitem-listitem foldout-enabled" @mouseover="loadFoldOutHub = true" aria-haspopup="true">
            <a data-v-67c0d35c class="topitem topitem-link" onclick="return false;" :href="hubnavigation.url" target="_blank"  v-touch:tap="hubItemClick(hubnavigation)" >
                <strong data-v-67c0d35c>{{'Hub:' | translate}} </strong>                    
                {{hubnavigation.name}}
            </a>                
            <component data-v-67c0d35c class="topitem-foldout ms-bgColor-themePrimary ms-fontColor-themeLighterAlt" :class="[renderFoldOutInFullWidth ? 'topitem-foldout-fullwidth' : '']" v-if="loadFoldOutHub" v-bind:is="foldoutHubTemplate" :hubnavigation="hubnavigation" />
        </li>
    </ul>   
    <ul data-v-67c0d35c class="topitem-list local" v-if="localnavigation != null" v-on:mouseleave="mouseleave">
        <!-- Local navigation top item -->
        <li data-v-67c0d35c class="topitem-listitem foldout-enabled" @mouseover="loadFoldOutLocal = true" aria-haspopup="true">                                
            <a data-v-67c0d35c class="topitem topitem-link" :href="webUrl">
                <strong data-v-67c0d35c>{{'Local:' | translate}}</strong>
                {{webTitle}}
            </a>
            <component data-v-67c0d35c class="topitem-foldout ms-bgColor-themePrimary ms-fontColor-themeLighterAlt" :class="[renderFoldOutInFullWidth ? 'topitem-foldout-fullwidth' : '']" v-if="loadFoldOutLocal" v-bind:is="foldoutLocalTemplate" :localnavigation="localnavigation" :closeFoldouts="closeFoldouts" />
        </li>
    </ul>
</div>
`;
    component.styles = `
.horizontalmenu[data-v-67c0d35c] {
  background-color: "[theme: bodyBackground, default: #ffffff]";
  color: "[theme: themePrimary, default: #666666]";
}
.topitem-list[data-v-67c0d35c] {
  display: inline;
  margin: 0 0 0 0;
  padding: 0 0 0 0;
}
.topitem-listitem[data-v-67c0d35c] {
  display: inline-block;
  height: 40px;
  vertical-align: top;
  font-size: 15px;
}
.topitem-listitem.active[data-v-67c0d35c], .topitem-listitem[data-v-67c0d35c]:hover {
    color: "[theme: themePrimary, default: #282c2e]";
    background-color: "[theme: themeLighter, default: #dbdbdb]";
}
.topitem-listitem .topitem-foldout[data-v-67c0d35c] {
    box-shadow: 0px 15px 10px -15px rgba(0, 0, 0, 0.25);
    position: absolute;
    display: none;
    z-index: 100;
}
.topitem-listitem .topitem-foldout.topitem-foldout-fullwidth[data-v-67c0d35c] {
      left: 0;
      right: 0;
}
.topitem-listitem:hover .topitem-foldout[data-v-67c0d35c] {
    display: block;
}
.topitem-listitem > div[data-v-67c0d35c] {
    display: inline-block;
}
.topitem[data-v-67c0d35c] {
  display: inline-block;
  padding: 10px 30px;
}
.topitem-link[data-v-67c0d35c] {
  color: inherit;
  text-decoration: none;
}
.topitem-text[data-v-67c0d35c] {
  cursor: default;
}
.topitem-html[data-v-67c0d35c] > p {
  margin: 0px;
}


`;

    return component;

});
